/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWInstruction;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWComponentInstructionsTableModel
extends AbstractTableModel {
    public static final int NUM_COLUMNS = 2;
    public static final int COL_NAME = 0;
    public static final int COL_COMPONENT = 1;
    public static final int COL_PARAMS = 2;
    private VWAuthPropertyData m_authPropertyData = null;
    private Vector m_rowData = null;
    private VWCompoundStepDefinition m_stepDefinition = null;

    public VWComponentInstructionsTableModel(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize(VWCompoundStepDefinition stepDefinition) {
        try {
            VWInstructionDefinition[] instructionDefs;
            this.m_rowData = new Vector();
            this.m_stepDefinition = stepDefinition;
            if (stepDefinition != null && (instructionDefs = stepDefinition.getInstructions()) != null && instructionDefs.length > 0) {
                for (int i = 0; i < instructionDefs.length; ++i) {
                    if (instructionDefs[i].getAction() != 23) continue;
                    this.m_rowData.addElement(instructionDefs[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItems(String queueName, VWOperationDefinition[] vwOperationDefs) {
        try {
            if (this.m_stepDefinition != null && vwOperationDefs != null && vwOperationDefs.length > 0) {
                String[] params = null;
                for (int i = 0; i < vwOperationDefs.length; ++i) {
                    VWParameterDefinition[] vwParameterDefs = vwOperationDefs[i].getParameterDefinitions();
                    if (vwParameterDefs != null && vwParameterDefs.length > 0) {
                        params = new String[vwParameterDefs.length];
                        for (int nIndex = 0; nIndex < vwParameterDefs.length; ++nIndex) {
                            VWFieldDefinition fieldDef = this.m_authPropertyData.getField(vwParameterDefs[nIndex].getName());
                            params[nIndex] = fieldDef != null && fieldDef.getFieldType() == vwParameterDefs[nIndex].getDataType() && fieldDef.isArray() == vwParameterDefs[nIndex].getIsArray() ? vwParameterDefs[nIndex].getName() : null;
                        }
                    } else {
                        params = new String[]{};
                    }
                    VWInstructionDefinition instructionDef = this.m_stepDefinition.createExecuteInstruction(queueName, vwOperationDefs[i].getName(), params);
                    this.m_rowData.addElement(instructionDef);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.fireTableDataChanged();
        }
    }

    public VWInstructionDefinition getItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        return (VWInstructionDefinition)this.m_rowData.elementAt(nRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveItemUp(int nRowIndex) {
        try {
            if (this.m_rowData == null || nRowIndex < 1 || nRowIndex > this.m_rowData.size()) {
                return;
            }
            VWInstructionDefinition instructionDef = (VWInstructionDefinition)this.m_rowData.remove(nRowIndex);
            this.m_rowData.insertElementAt(instructionDef, nRowIndex - 1);
            Object[] instructionDefs = new VWInstructionDefinition[this.m_rowData.size()];
            this.m_rowData.copyInto(instructionDefs);
            this.m_stepDefinition.setInstructions((VWInstructionDefinition[])instructionDefs);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.fireTableRowsUpdated(nRowIndex - 1, nRowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveItemDown(int nRowIndex) {
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size() - 1) {
                return;
            }
            VWInstructionDefinition instructionDef = (VWInstructionDefinition)this.m_rowData.remove(nRowIndex);
            this.m_rowData.insertElementAt(instructionDef, nRowIndex + 1);
            Object[] instructionDefs = new VWInstructionDefinition[this.m_rowData.size()];
            this.m_rowData.copyInto(instructionDefs);
            this.m_stepDefinition.setInstructions((VWInstructionDefinition[])instructionDefs);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.fireTableRowsUpdated(nRowIndex, nRowIndex + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteItem(int nRowIndex) {
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
                return;
            }
            VWInstructionDefinition instructionDef = (VWInstructionDefinition)this.m_rowData.remove(nRowIndex);
            this.m_stepDefinition.deleteInstruction(instructionDef.getInstructionId());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_nameStr;
            }
            case 1: {
                return VWResource.s_component;
            }
            case 2: {
                return "";
            }
        }
        return null;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String[].class;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWInstructionDefinition instructionDef = this.getItemAt(nRowIndex);
            if (instructionDef == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return VWInstruction.ExecuteInstructionGetOperationName(instructionDef);
                }
                case 1: {
                    return VWInstruction.ExecuteInstructionGetQueueName(instructionDef);
                }
                case 2: {
                    return VWInstruction.ExecuteInstructionGetParameterList(instructionDef);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

